<?php

/**
* This class is intended for testing during plugin development, it is not for
* general use and will not work with all URLs and websites.
*/
class FlexiCache_Test {

	/**
	* Store response content and md5s for comparison
	*/
	private $_aResponseContent = array();
	private $_aResponseMd5 = array();
	private $_aResponseCount = array();

	/**
	* List of link URLs per response
	*/
	private $_aResponseUrl;

	/**
	* Total responses fetched and a timer to note when we started
	*/
	private $_iResponseCount = 0;
	private $_iTimer = 0;
	private $_iMatchError = 0;

	/**
	* URL defaults
	*/
	private static $_aUrlDefault = array (
		'scheme'	=> 'http',
		'host'		=> 'localhost',
		'port'		=> 80,
		'path'		=> '/'
	);

	/**
	* cURL options
	*/
	private static $aCurlOpt = array (
		CURLOPT_FAILONERROR		=> false,
		CURLOPT_FOLLOWLOCATION	=> true,
		CURLOPT_HEADER			=> false,
		CURLOPT_RETURNTRANSFER	=> true,
		CURLOPT_CONNECTTIMEOUT	=> 3,
		CURLOPT_MAXREDIRS		=> 3
	);

	public function __construct ($sUrl=null)
	{

		if (null == $sUrl) {
			die ("Object must be initialized with a start URL");
		}

		/**
		* Parse the URL and generate a new string from _urlArrayToString()
		* which will apply defaults to any missing keys
		*/
		$sUrl = $this->_urlArrayToString(parse_url($sUrl));

		printf("starting with URL: %s\n", $sUrl);

		/**
		* Start the timer
		*/
		$this->_iTimer = microtime(true);

		do {

			/**
			* Fetch the URL, store it and check it.
			*/
			$sResponse = $this->fetch($sUrl);
			$this->storeCheckResponse($sUrl, $sResponse);

			/**
			* Increment the response counter
			*/
			++$this->_iResponseCount;

			if (0 == ($this->_iResponseCount%100)) {

				/**
				* Show status every 100 responses
				*/

				printf("%s %d done (%0.2f rps), %d unique, %d match errors\n",
					date('H:i:s',time()),
					$this->_iResponseCount,
					$this->_iResponseCount/(microtime(true)-$this->_iTimer),
					count($this->_aResponseMd5),
					$this->_iMatchError
				);

			}

		} while (false != ($sUrl = $this->getNextUrl($sUrl)));

	}

	/**
	* Generate a URL string from an array generated by parse_url(),
	* using defaults for any missing keys.
	*/
	private function _urlArrayToString ($aUrl)
	{

		/**
		* Apply defaults to unset keys
		*/
		$aUrl = array_merge(self::$_aUrlDefault, $aUrl);

		return sprintf('%s://%s:%d%s',
			$aUrl['scheme'],
			$aUrl['host'],
			$aUrl['port'],
			$aUrl['path']
		);

	}

	/**
	* Make a note of the given URL's content and MD5.  If the URL has been
	* noted previously and the new one is different, display an error
	*/
	private function storeCheckResponse ($sUrl, $sResponse)
	{

		/**
		* Remove FlexiCache comments as these are different every time
		*/
		$sResponse = trim(preg_replace('#<!-- ' . FlexiCache_Response::COMMENT_PREFIX . '.*-->#', '', $sResponse));

		if (false == isset($this->_aResponseMd5[$sUrl])) {

			/**
			* New responses, just store it
			*/

			$this->_aResponseMd5[$sUrl] = md5($sResponse);
			$this->_aResponseContent[$sUrl] = $sResponse;
			$this->_aResponseCount[$sUrl] = 1;

		} else if ($this->_aResponseMd5[$sUrl] != md5($sResponse)) {

			/**
			* Previously-encountered response which is different
			* to the version that was originally stored
			*/

			printf("md5 match error for %s\n", $sUrl);
			++$this->_iMatchError;

		}

		++$this->_aResponseCount[$sUrl];

	}

	/**
	* Get a list of internal links which are contained within the response
	* returned for $sCurrentUrl.  Assume that $sCurrentUrl has already
	* been retrieved and the content stored.
	*/
	private function getResponseUrls ($sCurrentUrl)
	{

		if (false == isset($this->_aResponseUrl[$sCurrentUrl])) {

			$this->_aResponseUrl[$sCurrentUrl] = array();

			$aCurrentUrl = parse_url($sCurrentUrl);

			/**
			* Match all standard links in $sHtml
			*/
			preg_match_all('#<a[^>]+href=([\'"])(.*)\\1>#iU', $this->_aResponseContent[$sCurrentUrl], $aCapture);

			foreach ($aCapture[2] as $sLink) {

				$aUrl = parse_url($sLink);

				/**
				* If the URL has no path, ignore it
				*/
				if (true == empty($aUrl['path'])) {
					continue;
				}

				/**
				* If the URL is not http, ignore it
				*/
				if (true == isset($aUrl['scheme']) && 'http' != $aUrl['scheme']) {
					continue;
				}

				/**
				* If the URL has a host which is different from the current
				* host, ignore it.
				*/
				if ((false == empty($aUrl['host'])) && ($aUrl['host'] != $aCurrentUrl['host'])) {
					continue;
				}

				/**
				* Apply defaults from current URL to unset keys
				*/
				$aUrl = array_merge($aCurrentUrl, $aUrl);

				/**
				* Generate a full URL string and append to array of potential
				* next URLs
				*/
				array_push($this->_aResponseUrl[$sCurrentUrl], $this->_urlArrayToString($aUrl));

			}

		}

		return $this->_aResponseUrl[$sCurrentUrl];

	}

	/**
	* Get a random URL from the local links contained with $sHtml.  If none
	* exists, use a random URL which has been fetched previously
	*/
	private function getNextUrl ($sCurrentUrl)
	{

		$aResponseUrl = $this->getResponseUrls($sCurrentUrl);

		/**
		* If there are no URLs in the array, pick a random URL which has been
		* fetched previously
		*/
		if (0 == count($aResponseUrl)) {
			$aPreviousUrl = array_keys($this->_aResponseMd5);
			return $aPreviousUrl[mt_rand(0,count($aPreviousUrl)-1)];
		}

		/**
		* Return a random URL from the array
		*/
		return $aResponseUrl[mt_rand(0,count($aResponseUrl)-1)];

	}

	/**
	* Fetch a URL and return the body content
	*/
	public function fetch ($sUrl)
	{

		if (false == ($rCh = curl_init($sUrl))) {
			die("curl_init() failed");
		}

		if (false == curl_setopt_array($rCh, self::$aCurlOpt)) {
			die("curl_setopt_array() failed");
		}

		if (false === ($sResponse = curl_exec($rCh))) {
//			echo "curl_exec() failed for $sUrl\n";
			return false;
		}

		$aInfo = curl_getinfo($rCh);
		$iDeclaredContentLength = (int) $aInfo['download_content_length'];
		$iActualContentLength = strlen($sResponse);

		if (($iDeclaredContentLength > 0) && ($iDeclaredContentLength != $iActualContentLength)) {

			printf("Returned response length %s bytes didn't match declared length of %s bytes\n",
				number_format($iActualContentLength),
				number_format($iDeclaredContentLength)
			);

		}

		return $sResponse;

	}

}
